<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalPaymentOrdersTable extends Migration {

	public function up()
	{
		Schema::create('legal_payment_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->double('payed_amount')->nullable();
			$table->double('remaining_amount')->nullable();
			$table->date('payed_date')->nullable();
			$table->integer('execution_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('legal_payment_orders');
	}
}