<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTmpJackTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('tmp_jack_transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('transaction_number')->nullable();
			$table->double('value')->nullable();
			$table->boolean('is_reconciliation')->nullable();
			$table->integer('jack_customer_id')->nullable();
			$table->enum('paymet_method', array('jack', 'maak', 'pay'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tmp_jack_transactions');
	}
}