<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tmb_jack_customers', function(Blueprint $table) {
			$table->foreign('manager_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->foreign('income_type_id')->references('id')->on('income_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->foreign('Bank_id')->references('id')->on('tmp_customer_bank_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->foreign('Instelemnt_id')->references('id')->on('tmp_installments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->foreign('vendor_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->foreign('source_treasury_id')->references('id')->on('treasuries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->foreign('destination_treasury_id')->references('id')->on('treasuries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->foreign('system_account_id')->references('id')->on('system_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('treasury_transfers', function(Blueprint $table) {
			$table->foreign('source_treasury_id')->references('id')->on('treasuries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('treasury_transfers', function(Blueprint $table) {
			$table->foreign('destination_treasury_id')->references('id')->on('treasuries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('treasury_transfers', function(Blueprint $table) {
			$table->foreign('bank_id')->references('id')->on('tmp_customer_bank_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('system_accounts', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('notification_name_id')->references('id')->on('notification_names')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('source_customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('destination_customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('source_bank_id')->references('id')->on('tmp_customer_bank_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('destination_bank_id')->references('id')->on('tmp_customer_bank_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounting_restrictions', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('accounting_restrictions', function(Blueprint $table) {
			$table->foreign('restriction_type')->references('id')->on('restriction_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('restriction_items', function(Blueprint $table) {
			$table->foreign('system_account_id')->references('id')->on('system_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('restriction_items', function(Blueprint $table) {
			$table->foreign('accounting_restriction_id')->references('id')->on('accounting_restrictions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fi_custodies', function(Blueprint $table) {
			$table->foreign('expense_type_id')->references('id')->on('fi_expense_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->foreign('asset_category_id')->references('id')->on('fi_asset_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->foreign('asset_account_id')->references('id')->on('system_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->foreign('depreciation_expense_account')->references('id')->on('system_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->foreign('depreciation_collection_account')->references('id')->on('system_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fi_asset_categories', function(Blueprint $table) {
			$table->foreign('system_account_id')->references('id')->on('system_accounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('asset_attachments', function(Blueprint $table) {
			$table->foreign('asset_id')->references('id')->on('fi_assets')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_consulting_attachments', function(Blueprint $table) {
			$table->foreign('consulting_id')->references('id')->on('legal_consultings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_consulting_texts', function(Blueprint $table) {
			$table->foreign('consulting_id')->references('id')->on('legal_consultings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_opinions', function(Blueprint $table) {
			$table->foreign('consulting_text_id')->references('id')->on('legal_consulting_texts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_company_lawsuits', function(Blueprint $table) {
			$table->foreign('judicial_department_id')->references('id')->on('legal_judicial_departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_company_lawsuits', function(Blueprint $table) {
			$table->foreign('execution_id')->references('id')->on('legal_company_lawsuit_executions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_company_lawsuits', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_judicial_departments', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('legal_regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_judicial_departments', function(Blueprint $table) {
			$table->foreign('court_id')->references('id')->on('legal_courts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_execution_decisions', function(Blueprint $table) {
			$table->foreign('execution_id')->references('id')->on('legal_company_lawsuit_executions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_execution_decisions', function(Blueprint $table) {
			$table->foreign('decision_id')->references('id')->on('legal_decisions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_payment_orders', function(Blueprint $table) {
			$table->foreign('execution_id')->references('id')->on('legal_company_lawsuit_executions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_company_lawsuit_sessions', function(Blueprint $table) {
			$table->foreign('company_lawsuit_id')->references('id')->on('legal_company_lawsuits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_company_lawsuit_attatchments', function(Blueprint $table) {
			$table->foreign('company_lawsuit_id')->references('id')->on('legal_company_lawsuits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_against_company_lawsuits', function(Blueprint $table) {
			$table->foreign('court_id')->references('id')->on('legal_courts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_against_company_lawsuits', function(Blueprint $table) {
			$table->foreign('judicial_department_id')->references('id')->on('legal_judicial_departments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_against_company_lawsuits', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_against_company_lawsuit_sessions', function(Blueprint $table) {
			$table->foreign('against_company_lawsuit_id')->references('id')->on('legal_against_company_lawsuits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_against_company_lawsuit_attatchments', function(Blueprint $table) {
			$table->foreign('against_company_lawsuit_id')->references('id')->on('legal_against_company_lawsuits')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->foreign('attorney_type_id')->references('id')->on('legal_power_attorney_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('legal_countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->foreign('power_attorney_text_id')->references('id')->on('legal_power_attorney_texts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->foreign('power_attorney_item_id')->references('id')->on('legal_power_attorney_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_power_attorney_attachments', function(Blueprint $table) {
			$table->foreign('power_attorney_id')->references('id')->on('legal_power_attorney')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_regions', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('legal_countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_courts', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('legal_regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_investigation_attachments', function(Blueprint $table) {
			$table->foreign('investigation_id')->references('id')->on('legal_investigations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('legal_investigation_questions', function(Blueprint $table) {
			$table->foreign('investigation_id')->references('id')->on('legal_investigations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tmp_customer_attachments', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('tmp_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('risk_alert_setting_items', function(Blueprint $table) {
			$table->foreign('parent')->references('id')->on('risk_alert_setting_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('risk_alerts', function(Blueprint $table) {
			$table->foreign('risk_setting_id')->references('id')->on('risk_alert_settings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('risk_alerts', function(Blueprint $table) {
			$table->foreign('jack_customer_id')->references('id')->on('tmb_jack_customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('risk_alert_attachments', function(Blueprint $table) {
			$table->foreign('risk_alert_id')->references('id')->on('risk_alerts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tmb_jack_customers', function(Blueprint $table) {
			$table->dropForeign('tmb_jack_customers_manager_id_foreign');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->dropForeign('incomes_income_type_id_foreign');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->dropForeign('incomes_customer_id_foreign');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->dropForeign('incomes_vendor_id_foreign');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->dropForeign('incomes_Bank_id_foreign');
		});
		Schema::table('incomes', function(Blueprint $table) {
			$table->dropForeign('incomes_Instelemnt_id_foreign');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->dropForeign('outcomes_vendor_id_foreign');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->dropForeign('outcomes_source_treasury_id_foreign');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->dropForeign('outcomes_destination_treasury_id_foreign');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->dropForeign('outcomes_customer_id_foreign');
		});
		Schema::table('outcomes', function(Blueprint $table) {
			$table->dropForeign('outcomes_system_account_id_foreign');
		});
		Schema::table('treasury_transfers', function(Blueprint $table) {
			$table->dropForeign('treasury_transfers_source_treasury_id_foreign');
		});
		Schema::table('treasury_transfers', function(Blueprint $table) {
			$table->dropForeign('treasury_transfers_destination_treasury_id_foreign');
		});
		Schema::table('treasury_transfers', function(Blueprint $table) {
			$table->dropForeign('treasury_transfers_bank_id_foreign');
		});
		Schema::table('system_accounts', function(Blueprint $table) {
			$table->dropForeign('system_accounts_parent_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_notification_name_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_source_customer_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_destination_customer_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_source_bank_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_destination_bank_id_foreign');
		});
		Schema::table('accounting_restrictions', function(Blueprint $table) {
			$table->dropForeign('accounting_restrictions_customer_id_foreign');
		});
		Schema::table('accounting_restrictions', function(Blueprint $table) {
			$table->dropForeign('accounting_restrictions_restriction_type_foreign');
		});
		Schema::table('restriction_items', function(Blueprint $table) {
			$table->dropForeign('restriction_items_system_account_id_foreign');
		});
		Schema::table('restriction_items', function(Blueprint $table) {
			$table->dropForeign('restriction_items_accounting_restriction_id_foreign');
		});
		Schema::table('fi_custodies', function(Blueprint $table) {
			$table->dropForeign('fi_custodies_expense_type_id_foreign');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->dropForeign('fi_assets_asset_category_id_foreign');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->dropForeign('fi_assets_asset_account_id_foreign');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->dropForeign('fi_assets_depreciation_expense_account_foreign');
		});
		Schema::table('fi_assets', function(Blueprint $table) {
			$table->dropForeign('fi_assets_depreciation_collection_account_foreign');
		});
		Schema::table('fi_asset_categories', function(Blueprint $table) {
			$table->dropForeign('fi_asset_categories_system_account_id_foreign');
		});
		Schema::table('asset_attachments', function(Blueprint $table) {
			$table->dropForeign('asset_attachments_asset_id_foreign');
		});
		Schema::table('legal_consulting_attachments', function(Blueprint $table) {
			$table->dropForeign('legal_consulting_attachments_consulting_id_foreign');
		});
		Schema::table('legal_consulting_texts', function(Blueprint $table) {
			$table->dropForeign('legal_consulting_texts_consulting_id_foreign');
		});
		Schema::table('legal_opinions', function(Blueprint $table) {
			$table->dropForeign('legal_opinions_consulting_text_id_foreign');
		});
		Schema::table('legal_company_lawsuits', function(Blueprint $table) {
			$table->dropForeign('legal_company_lawsuits_judicial_department_id_foreign');
		});
		Schema::table('legal_company_lawsuits', function(Blueprint $table) {
			$table->dropForeign('legal_company_lawsuits_execution_id_foreign');
		});
		Schema::table('legal_company_lawsuits', function(Blueprint $table) {
			$table->dropForeign('legal_company_lawsuits_customer_id_foreign');
		});
		Schema::table('legal_judicial_departments', function(Blueprint $table) {
			$table->dropForeign('legal_judicial_departments_region_id_foreign');
		});
		Schema::table('legal_judicial_departments', function(Blueprint $table) {
			$table->dropForeign('legal_judicial_departments_court_id_foreign');
		});
		Schema::table('legal_execution_decisions', function(Blueprint $table) {
			$table->dropForeign('legal_execution_decisions_execution_id_foreign');
		});
		Schema::table('legal_execution_decisions', function(Blueprint $table) {
			$table->dropForeign('legal_execution_decisions_decision_id_foreign');
		});
		Schema::table('legal_payment_orders', function(Blueprint $table) {
			$table->dropForeign('legal_payment_orders_execution_id_foreign');
		});
		Schema::table('legal_company_lawsuit_sessions', function(Blueprint $table) {
			$table->dropForeign('legal_company_lawsuit_sessions_company_lawsuit_id_foreign');
		});
		Schema::table('legal_company_lawsuit_attatchments', function(Blueprint $table) {
			$table->dropForeign('legal_company_lawsuit_attatchments_company_lawsuit_id_foreign');
		});
		Schema::table('legal_against_company_lawsuits', function(Blueprint $table) {
			$table->dropForeign('legal_against_company_lawsuits_court_id_foreign');
		});
		Schema::table('legal_against_company_lawsuits', function(Blueprint $table) {
			$table->dropForeign('legal_against_company_lawsuits_judicial_department_id_foreign');
		});
		Schema::table('legal_against_company_lawsuits', function(Blueprint $table) {
			$table->dropForeign('legal_against_company_lawsuits_customer_id_foreign');
		});
		Schema::table('legal_against_company_lawsuit_sessions', function(Blueprint $table) {
			$table->dropForeign('legal_against_company_lawsuit_sessions_against_company_lawsuit_id_foreign');
		});
		Schema::table('legal_against_company_lawsuit_attatchments', function(Blueprint $table) {
			$table->dropForeign('legal_against_company_lawsuit_attatchments_against_company_lawsuit_id_foreign');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->dropForeign('legal_power_attorney_attorney_type_id_foreign');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->dropForeign('legal_power_attorney_country_id_foreign');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->dropForeign('legal_power_attorney_power_attorney_text_id_foreign');
		});
		Schema::table('legal_power_attorney', function(Blueprint $table) {
			$table->dropForeign('legal_power_attorney_power_attorney_item_id_foreign');
		});
		Schema::table('legal_power_attorney_attachments', function(Blueprint $table) {
			$table->dropForeign('legal_power_attorney_attachments_power_attorney_id_foreign');
		});
		Schema::table('legal_regions', function(Blueprint $table) {
			$table->dropForeign('legal_regions_country_id_foreign');
		});
		Schema::table('legal_courts', function(Blueprint $table) {
			$table->dropForeign('legal_courts_region_id_foreign');
		});
		Schema::table('legal_investigation_attachments', function(Blueprint $table) {
			$table->dropForeign('legal_investigation_attachments_investigation_id_foreign');
		});
		Schema::table('legal_investigation_questions', function(Blueprint $table) {
			$table->dropForeign('legal_investigation_questions_investigation_id_foreign');
		});
		Schema::table('tmp_customer_attachments', function(Blueprint $table) {
			$table->dropForeign('tmp_customer_attachments_customer_id_foreign');
		});
		Schema::table('risk_alert_setting_items', function(Blueprint $table) {
			$table->dropForeign('risk_alert_setting_items_parent_foreign');
		});
		Schema::table('risk_alerts', function(Blueprint $table) {
			$table->dropForeign('risk_alerts_risk_setting_id_foreign');
		});
		Schema::table('risk_alerts', function(Blueprint $table) {
			$table->dropForeign('risk_alerts_jack_customer_id_foreign');
		});
		Schema::table('risk_alert_attachments', function(Blueprint $table) {
			$table->dropForeign('risk_alert_attachments_risk_alert_id_foreign');
		});
	}
}