<?php

namespace App\Modules\Finance\Migrations\AccountingRestriction;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AccountingRestriction extends Eloquent {

	protected $table = 'accounting_restrictions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function restrictionType()
	{
		return $this->belongsTo('RestrictionType', 'restriction_type');
	}

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

}