<?php

namespace App\Modules\Legal\Migrations\AgainstCompanyLawsuitSession;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AgainstCompanyLawsuitSession extends Eloquent {

	protected $table = 'legal_against_company_lawsuit_sessions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function againstCompanyLawsuit()
	{
		return $this->belongsTo('AgainstCompanyLawsuits', 'against_company_lawsuit_id');
	}

}