<?php

namespace App\Modules\Legal\Migrations\AgainstCompanyLawsuits;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AgainstCompanyLawsuits extends Eloquent {

	protected $table = 'legal_against_company_lawsuits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function department()
	{
		return $this->belongsTo('JudicialDepartment', 'judicial_department_id');
	}

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

	public function court()
	{
		return $this->belongsTo('Court', 'court_id');
	}

}