<?php

namespace App\Modules\Finance\Migrations\Asset;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Asset extends Eloquent {

	protected $table = 'fi_assets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function assetCategory()
	{
		return $this->belongsTo('AssetCategory', 'asset_category_id');
	}

	public function assetAccount()
	{
		return $this->belongsTo('SystemAccounts', 'asset_account_id');
	}

	public function depreciationExpense()
	{
		return $this->belongsTo('SystemAccounts', 'depreciation_account_id');
	}

	public function depreciationCollection()
	{
		return $this->belongsTo('SystemAccounts', 'depreciation_collection_id');
	}

}