<?php

namespace App\Modules\Legal\Migrations\companyLawsuits;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CompanyLawsuits extends Eloquent {

	protected $table = 'legal_company_lawsuits';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function judicialDepartment()
	{
		return $this->belongsTo('JudicialDepartment', 'judicial_department_id');
	}

	public function execution()
	{
		return $this->belongsTo('CompanyLawsuitExecutions', 'execution_id');
	}

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

}