<?php

namespace App\Modules\TempApplication\CustomerAttachment;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CustomerAttachment extends Eloquent {

	protected $table = 'tmp_customer_attachments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

}