<?php

namespace App\Modules\TempApplication\Migrations\CustomerBankAccount;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CustomerBankAccount extends Eloquent {

	protected $table = 'tmp_customer_bank_account';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

}