<?php

namespace App\Modules\Legal\Migrations\ExecutionDecisions;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ExecutionDecisions extends Eloquent {

	protected $table = 'legal_execution_decisions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function execution()
	{
		return $this->belongsTo('CompanyLawsuitExecutions', 'execution_id');
	}

	public function decision()
	{
		return $this->belongsTo('Decisions', 'decision_id');
	}

}