<?php

namespace App\Modules\Finance\Migrations\Income;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Income extends Eloquent {

	protected $table = 'incomes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

	public function vendor()
	{
		return $this->belongsTo('Customer', 'vendor_id');
	}

	public function bank()
	{
		return $this->belongsTo('CustomerBankAccount', 'bank_id');
	}

	public function installment()
	{
		return $this->belongsTo('Installment', 'installment_id');
	}

	public function treasury()
	{
		return $this->belongsTo('Treasury', 'treasury_id');
	}

	public function incomeType()
	{
		return $this->belongsTo('IncomeType', 'income_type_id');
	}

}