<?php

namespace App\Modules\TempApplication\Migrations\Installment;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Installment extends Eloquent {

	protected $table = 'tmp_installments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function transaction()
	{
		return $this->belongsTo('MaakTransaction', 'transaction_id');
	}

	public function vendor()
	{
		return $this->belongsTo('JackCustomer', 'jack_customer_id');
	}

	public function customer()
	{
		return $this->belongsTo('MaakCustomer', 'maak_customer_id');
	}

}