<?php

namespace App\Modules\TempApplication\Migrations\jackCustomer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class JackCustomer extends Eloquent {

	protected $table = 'tmb_jack_customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

	public function manager()
	{
		return $this->belongsTo('Customer', 'manager_id');
	}

}