<?php

namespace App\Modules\TempApplication\Migrations\MaakTransaction;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class MaakTransaction extends Eloquent {

	protected $table = 'tmp_maak_transactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function vendor()
	{
		return $this->belongsTo('JackCustomer', 'jack_customer_id');
	}

	public function maak()
	{
		return $this->belongsTo('MaakCustomer', 'maak_customer_id');
	}

}