<?php

namespace App\Modules\Finance\Migrations\Outcome;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Outcome extends Eloquent {

	protected $table = 'outcomes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

	public function sourceTreasury()
	{
		return $this->belongsTo('Treasury', 'source_treasury_id');
	}

	public function destinationTreasury()
	{
		return $this->belongsTo('Treasury', 'destination_treasury_id');
	}

	public function systemAccounts()
	{
		return $this->belongsTo('SystemAccounts', 'system_account_id');
	}

}