<?php

namespace App\Modules\TempApplication\Migrations\payCustomer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PayCustomer extends Eloquent {

	protected $table = 'tmp_pay_customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customer()
	{
		return $this->belongsTo('Customer', 'customer_id');
	}

	public function vendor()
	{
		return $this->belongsTo('TmpPayVendor', 'pay_vendor_id');
	}

}