<?php

namespace App\Modules\Legal\Migrations\PowerAttorney;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PowerAttorney extends Eloquent {

	protected $table = 'legal_power_attorney';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function powerAttorneyText()
	{
		return $this->belongsTo('PowerAttorneyText', 'power_attorney_text_id');
	}

	public function powerAttorneyItem()
	{
		return $this->belongsTo('PowerAttorneyItem', 'power_attorney_item_id');
	}

	public function powerAttorneyType()
	{
		return $this->belongsTo('PowerAttorneyTypes', 'power_attorney_type');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}