<?php

namespace App\Modules\Finance\Migrations\RestrictionItem;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RestrictionItem extends Eloquent {

	protected $table = 'restriction_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function systemAccount()
	{
		return $this->belongsTo('SystemAccounts', 'system_account_id');
	}

	public function accountingRestriction()
	{
		return $this->belongsTo('AccountingRestriction', 'accounting_restriction_id');
	}

}