<?php

namespace App\Modules\Risk\RiskAlert;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RiskAlert extends Eloquent {

	protected $table = 'risk_alerts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function riskSetting()
	{
		return $this->belongsTo('RiskAlertSetting', 'risk_setting_id');
	}

	public function customer()
	{
		return $this->belongsTo('JackCustomer', 'jack_customer_id');
	}

}