<?php

namespace App\Modules\TempApplication\Migrations\tmpPayTransaction;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TmpPayTransaction extends Eloquent {

	protected $table = 'tmp_pay_transactions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function reciver()
	{
		return $this->belongsTo('Customer', 'reciver_id');
	}

	public function payCustomer()
	{
		return $this->belongsTo('PayCustomer', 'pay_customer_id');
	}

}