<?php

namespace App\Modules\Finance\Migrations\TreasuryTransfer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TreasuryTransfer extends Eloquent {

	protected $table = 'treasury_transfers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sourceTreasury()
	{
		return $this->belongsTo('Treasury', 'source_treasury_id');
	}

	public function destinationTreasury()
	{
		return $this->belongsTo('Treasury', 'destination_treasury_id');
	}

	public function bank()
	{
		return $this->belongsTo('CustomerBankAccount', 'bank_id');
	}

}