<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->text('description');
			$table->text('content');
			$table->integer('user_id')->unsigned();
			$table->boolean('popular')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}