<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AnsweredData extends Model 
{

    protected $table = 'answered_data';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('fk_location_id', 'fk_question', 'fk_answer');

    public function locationData()
    {
        return $this->hasOne('UserData');
    }

    public function question()
    {
        return $this->hasOne('Questions');
    }

    public function answers()
    {
        return $this->hasOne('Answers');
    }

}