<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('fk_question')->references('question_id')->on('questions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('answered_data', function(Blueprint $table) {
			$table->foreign('fk_location_id')->references('answered_data_id')->on('answered_data')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('answered_data', function(Blueprint $table) {
			$table->foreign('fk_question')->references('question_id')->on('questions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('answered_data', function(Blueprint $table) {
			$table->foreign('fk_answer')->references('answer_id')->on('answers')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_fk_question_foreign');
		});
		Schema::table('answered_data', function(Blueprint $table) {
			$table->dropForeign('answered_data_fk_location_id_foreign');
		});
		Schema::table('answered_data', function(Blueprint $table) {
			$table->dropForeign('answered_data_fk_question_foreign');
		});
		Schema::table('answered_data', function(Blueprint $table) {
			$table->dropForeign('answered_data_fk_answer_foreign');
		});
	}
}