<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Package extends Model 
{

    protected $table = 'package';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'speed_id', 'price');

    public function speed()
    {
        return $this->belongsTo('Speed', 'speed_id');
    }

}