<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('subscription_id')->nullable();
			$table->double('price')->nullable();
			$table->enum('status', array('paid', 'unpaid', 'cancelled'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}