<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Package extends Eloquent {

	protected $table = 'package';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'speed_id', 'price');

	public function speed()
	{
		return $this->belongsTo('Speed', 'speed_id');
	}

}