<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PauseRequest extends Eloquent {

	protected $table = 'pause_request';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('subscription_id', 'user_id', 'note', 'status');

	public function Subscription()
	{
		return $this->belongsTo('Subscription', 'subscription_id');
	}

	public function User()
	{
		return $this->belongsTo('User', 'user_id');
	}

}