<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubscriptionHistory extends Eloquent {

	protected $table = 'subscription_history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('subscription_id', 'action', 'user_id');

	public function subscription()
	{
		return $this->belongsTo('Subscription', 'subscription_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}