<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WorkingHours extends Eloquent {

	protected $table = 'working_hours';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'date', 'minutes');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}