<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CancelRequest extends Model 
{

    protected $table = 'cancel_request';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('subscription_id', 'user_id', 'note', 'status');

    public function subscription()
    {
        return $this->belongsTo('Subscription', 'subscription_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}