<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVouchersTable extends Migration {

	public function up()
	{
		Schema::create('vouchers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned()->nullable();
			$table->integer('product_id')->unsigned()->nullable();
			$table->string('code');
			$table->string('name');
			$table->enum('type', array('percentage', 'fixed'));
			$table->decimal('value');
			$table->integer('max_uses');
			$table->integer('max_uses_per_user')->nullable();
			$table->date('start_date');
			$table->string('end_date');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vouchers');
	}
}