<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductVariantsTable extends Migration {

	public function up()
	{
		Schema::create('product_variants', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id')->unsigned();
			$table->string('image_url');
			$table->decimal('price',  10, 2);
			$table->integer('stock');
			$table->string('sku');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product_variants');
	}
}