<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePharmacistsTable extends Migration {

	public function up()
	{
		Schema::create('pharmacists', function(Blueprint $table) {
			$table->increments('id');
			$table->string('username', 255);
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->integer('phone')->unique();
			$table->string('password', 255);
			$table->bigInteger('address_id')->unsigned();
			$table->bigInteger('settings_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('pharmacists');
	}
}