<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Medicine extends Model 
{

    protected $table = 'medicines';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function Favorites()
    {
        return $this->hasMany('Favorite');
    }

    public function Quantity()
    {
        return $this->hasOne('Quantity', 'id');
    }

    public function Categories()
    {
        return $this->hasMany('CategoryMedicine');
    }

    public function Options()
    {
        return $this->hasMany('MedicineOption');
    }

}