<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('medicines', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medicines', function(Blueprint $table) {
			$table->foreign('quantity_id')->references('id')->on('quantities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quantities', function(Blueprint $table) {
			$table->foreign('medicine_id')->references('id')->on('medicines')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('pharmacists', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('pharmacists', function(Blueprint $table) {
			$table->foreign('settings_id')->references('id')->on('settings')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('medicine_id')->references('id')->on('medicines')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('pharmacist_id')->references('id')->on('pharmacists')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('categories_medicines', function(Blueprint $table) {
			$table->foreign('medicine_id')->references('id')->on('medicines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categories_medicines', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('address_id')->references('id')->on('addresses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medicines_options', function(Blueprint $table) {
			$table->foreign('medicine_id')->references('id')->on('medicines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medicines_options', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('options')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('pharmacist_id')->references('id')->on('pharmacists')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('medicine_order_id')->references('medicine_id')->on('medicines_order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('medicines_order', function(Blueprint $table) {
			$table->foreign('medicine_id')->references('id')->on('medicines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('medicines', function(Blueprint $table) {
			$table->dropForeign('medicines_company_id_foreign');
		});
		Schema::table('medicines', function(Blueprint $table) {
			$table->dropForeign('medicines_quantity_id_foreign');
		});
		Schema::table('quantities', function(Blueprint $table) {
			$table->dropForeign('quantities_medicine_id_foreign');
		});
		Schema::table('pharmacists', function(Blueprint $table) {
			$table->dropForeign('pharmacists_address_id_foreign');
		});
		Schema::table('pharmacists', function(Blueprint $table) {
			$table->dropForeign('pharmacists_settings_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_medicine_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_pharmacist_id_foreign');
		});
		Schema::table('categories_medicines', function(Blueprint $table) {
			$table->dropForeign('categories_medicines_medicine_id_foreign');
		});
		Schema::table('categories_medicines', function(Blueprint $table) {
			$table->dropForeign('categories_medicines_category_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_address_id_foreign');
		});
		Schema::table('medicines_options', function(Blueprint $table) {
			$table->dropForeign('medicines_options_medicine_id_foreign');
		});
		Schema::table('medicines_options', function(Blueprint $table) {
			$table->dropForeign('medicines_options_option_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_pharmacist_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_medicine_order_id_foreign');
		});
		Schema::table('medicines_order', function(Blueprint $table) {
			$table->dropForeign('medicines_order_medicine_id_foreign');
		});
	}
}