<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMedicinesTable extends Migration {

	public function up()
	{
		Schema::create('medicines', function(Blueprint $table) {
			$table->increments('id');
			$table->string('scientificName', 255)->unique();
			$table->string('commercialName', 255)->unique();
			$table->integer('price');
			$table->date('expiry_date');
			$table->bigInteger('company_id')->unsigned();
			$table->bigInteger('quantity_id')->unsigned();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('medicines');
	}
}