<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampaignsTable extends Migration {

	public function up()
	{
		Schema::create('campaigns', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('org_id')->unsigned();
			$table->string('subject');
			$table->string('logo_url');
			$table->string('image_url');
			$table->string('contact');
			$table->string('address');
			$table->string('telephone');
			$table->integer('province_id');
			$table->integer('city_id');
			$table->integer('region_id');
			$table->string('zipcode');
			$table->string('longitude');
			$table->string('latitude');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->string('mark');
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('campaigns');
	}
}