<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClassroomsTable extends Migration {

	public function up()
	{
		Schema::create('classrooms', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('org_id')->unsigned();
			$table->integer('sort_id')->default('0');
			$table->string('mark', 1024);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('classrooms');
	}
}