<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentInfoTable extends Migration {

	public function up()
	{
		Schema::create('content_info', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('object_id');
			$table->integer('obj_type');
			$table->text('content');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->datetime('publish_date');
			$table->integer('operator_userid');
			$table->integer('operator_type');
			$table->string('short_desc');
			$table->string('long_desc', 1024);
		});
	}

	public function down()
	{
		Schema::drop('content_info');
	}
}