<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model 
{

    protected $table = 'transactions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('value', 'description', 'user_id', 'event_id');

    public function events()
    {
        return $this->belongsTo('App\Event');
    }

    public function users()
    {
        return $this->belongsTo('App\User');
    }

    public function refunds()
    {
        return $this->hasMany('App\Refund');
    }

}