<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Event extends Model 
{

    protected $table = 'events';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('description', 'starts_at', 'ends_at', 'user_id');

    public function transactions()
    {
        return $this->hasMany('App\Transaction');
    }

    public function users()
    {
        return $this->belongsToMany('App\User');
    }

}