<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('first_name', 'last_name', 'email', 'password');

    public function events()
    {
        return $this->belongsToMany('App\Event');
    }

    public function refunds()
    {
        return $this->hasMany('App\Refund');
    }

    public function transactions()
    {
        return $this->hasMany('App\Transaction');
    }

}