<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiclesTable extends Migration {

	public function up()
	{
		Schema::create('vehicles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->timestamps();
			$table->integer('status')->default('0');
			$table->datetime('start_at');
			$table->datetime('finish_at');
			$table->string('registration_mark', 20);
			$table->integer('cap_derivative_id');
		});
	}

	public function down()
	{
		Schema::drop('vehicles');
	}
}