<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 200)->unique();
			$table->string('password');
			$table->string('name', 200);
			$table->string('phone', 200)->unique();
			$table->string('photo', 255);
			$table->string('pin_code', 10)->nullable();
			$table->string('verification_token', 255)->nullable();
			$table->timestamp('token_created_at');
			$table->timestamp('pin_created_at');
			$table->tinyInteger('confirmed_email')->default('0');
			$table->timeTz('email_verified_at');
			$table->integer('company_id')->unsigned();
			$table->tinyInteger('is_approved')->default('0');
			$table->tinyInteger('approved_by')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}