<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEducationsTable extends Migration {

	public function up()
	{
		Schema::create('educations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('college', 200);
			$table->string('degree', 250);
			$table->string('field_of_study', 200);
			$table->date('start_date');
			$table->date('end_date');
			$table->integer('profile_id');
			$table->tinyInteger('is_current')->default('0');
			$table->string('description')->nullable();
			$table->string('location', 200);
			$table->string('image', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('educations');
	}
}