<?php

namespace App\Models;

class Application extends Eloquent {

	protected $table = 'applications';
	public $timestamps = true;
	protected $fillable = array('profile_id', 'job_id', 'status', 'cover_later', 'resume_path');

	public function profile()
	{
		return $this->hasOne('App\Models\Profile');
	}

	public function job()
	{
		return $this->hasOne('App\Models\Job');
	}

	public function status()
	{
		return $this->belongsToMany('App\Model\ApplicationStatusHistory');
	}

}