<?php

namespace App\Models;

class Job extends Eloquent {

	protected $table = 'jobs';
	public $timestamps = true;
	protected $fillable = array('title', 'company_id', 'category_name', 'jop_type', 'salary', 'description', 'requirement', 'position', 'job_status', 'location', 'benefits');

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function company()
	{
		return $this->belongsTo('App\Models\Company');
	}

	public function applications()
	{
		return $this->belongsToMany('App\Models\Application');
	}

	public function profiles()
	{
		return $this->belongsToMany('App\Models\Profile');
	}

	public function notifications()
	{
		return $this->hasMany('App\Models\Notification');
	}

}