<?php

namespace App\Models;

class Profile extends Eloquent {

	protected $table = 'profiles';
	public $timestamps = true;
	protected $fillable = array('user_id', 'title_job', 'profile_image', 'is_default', 'position_job');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function educations()
	{
		return $this->hasMany('App\Models\Education');
	}

	public function experiences()
	{
		return $this->hasMany('App\Models\Experience');
	}

	public function portfolio()
	{
		return $this->hasOne('App\Models\Document');
	}

	public function applications()
	{
		return $this->belongsToMany('App\Models\Application');
	}

	public function jobs()
	{
		return $this->belongsToMany('App\Models\Job');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function companies()
	{
		return $this->belongsToMany('App\Models\Company');
	}

}